package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.model.VdocOs4;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * VdocOs4DaoImpl generated by UDA, 29-jun-2017 8:32:42.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class VdocOs4DaoImpl implements VdocOs4Dao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<VdocOs4> rwMap = new RowMapper<VdocOs4>() {
		public VdocOs4 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VdocOs4(resultSet.getString("NUMEXP"),
					resultSet.getInt("NUMEJE"),
					resultSet.getString("DIRECCION"),
					resultSet.getString("PROMOTOR"),
					resultSet.getString("CONTRATA"),
					resultSet.getString("AVISOSI"),
					resultSet.getString("AVISONO"),
					resultSet.getString("COMUNICACIONSI"),
					resultSet.getString("COMUICACIONNO"),
					resultSet.getString("PLANSI"),
					resultSet.getString("PLANNO"),
					resultSet.getString("COORDINADOR"),
					resultSet.getInt("EXPEDIENTE"), resultSet.getDate("FECHA"),
					resultSet.getString("NOMBREEMPRESA"),
					resultSet.getString("PROMO"), resultSet.getString("CON"),
					resultSet.getString("SUBCON"), resultSet.getString("AUT"),
					resultSet.getString("NOMRES1"),
					resultSet.getString("NOMRES2"),
					resultSet.getString("DESRES1"),
					resultSet.getString("DESRES2"),
					resultSet.getString("NOMREP"),
					resultSet.getString("REPRESENTACION"),
					resultSet.getString("CODCAU01"),
					resultSet.getString("CODCAU02"),
					resultSet.getString("CODCAU03"),
					resultSet.getString("CODCAU04"),
					resultSet.getString("CODCAU05"),
					resultSet.getString("CODCAU06"),
					resultSet.getString("CODCAU07"),
					resultSet.getString("CODCAU08"),
					resultSet.getString("CODCAU09"),
					resultSet.getString("CODCAU10"),
					resultSet.getString("OBSERVACIONES"));
		}
	};

	private RowMapper<VdocOs4> rwMapPK = new RowMapper<VdocOs4>() {
		public VdocOs4 mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new VdocOs4(resultSet.getString("NUMEXP"),
					resultSet.getInt("NUMEJE"),
					resultSet.getString("DIRECCION"),
					resultSet.getString("PROMOTOR"),
					resultSet.getString("CONTRATA"),
					resultSet.getString("AVISOSI"),
					resultSet.getString("AVISONO"),
					resultSet.getString("COMUNICACIONSI"),
					resultSet.getString("COMUICACIONNO"),
					resultSet.getString("PLANSI"),
					resultSet.getString("PLANNO"),
					resultSet.getString("COORDINADOR"),
					resultSet.getInt("EXPEDIENTE"), resultSet.getDate("FECHA"),
					resultSet.getString("NOMBREEMPRESA"),
					resultSet.getString("PROMO"), resultSet.getString("CON"),
					resultSet.getString("SUBCON"), resultSet.getString("AUT"),
					resultSet.getString("NOMRES1"),
					resultSet.getString("NOMRES2"),
					resultSet.getString("DESRES1"),
					resultSet.getString("DESRES2"),
					resultSet.getString("NOMREP"),
					resultSet.getString("REPRESENTACION"),
					resultSet.getString("CODCAU01"),
					resultSet.getString("CODCAU02"),
					resultSet.getString("CODCAU03"),
					resultSet.getString("CODCAU04"),
					resultSet.getString("CODCAU05"),
					resultSet.getString("CODCAU06"),
					resultSet.getString("CODCAU07"),
					resultSet.getString("CODCAU08"),
					resultSet.getString("CODCAU09"),
					resultSet.getString("CODCAU10"),
					resultSet.getString("OBSERVACIONES"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the VdocOs4 table.
	 * 
	 *  vdocos4
	 *            VdocOs4
	 *  VdocOs4
	 *
	 * @param vdocos4 the vdocos 4
	 * @return the vdoc os 4
	 */
	public VdocOs4 add(VdocOs4 vdocos4) {
		String query = "INSERT INTO VDOC_OS4 (NUMEXP, NUMEJE, DIRECCION, PROMOTOR, CONTRATA, AVISOSI, AVISONO, COMUNICACIONSI, COMUICACIONNO, PLANSI, PLANNO, COORDINADOR, EXPEDIENTE, FECHA, NOMBREEMPRESA, PROMO, CON, SUBCON, AUT, NOMRES1, NOMRES2, DESRES1, DESRES2, NOMREP, REPRESENTACION, CODCAU01, CODCAU02, CODCAU03, CODCAU04, CODCAU05, CODCAU06, CODCAU07, CODCAU08, CODCAU09, CODCAU10, OBSERVACIONES) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, vdocos4.getNumexp(), vdocos4.getNumeje(),
				vdocos4.getDireccion(), vdocos4.getPromotor(),
				vdocos4.getContrata(), vdocos4.getAvisosi(),
				vdocos4.getAvisono(), vdocos4.getComunicacionsi(),
				vdocos4.getComunicacionno(), vdocos4.getPlansi(),
				vdocos4.getPlanno(), vdocos4.getCoordinador(),
				vdocos4.getExpediente(), vdocos4.getFecha(),
				vdocos4.getNombreempresa(), vdocos4.getPromo(),
				vdocos4.getCon(), vdocos4.getSubcon(), vdocos4.getAut(),
				vdocos4.getNomres1(), vdocos4.getNomres2(),
				vdocos4.getDesres1(), vdocos4.getDesres2(),
				vdocos4.getNomrep(), vdocos4.getRepresentacion(),
				vdocos4.getCodcau01(), vdocos4.getCodcau02(),
				vdocos4.getCodcau03(), vdocos4.getCodcau04(),
				vdocos4.getCodcau05(), vdocos4.getCodcau06(),
				vdocos4.getCodcau07(), vdocos4.getCodcau08(),
				vdocos4.getCodcau09(), vdocos4.getCodcau10(),
				vdocos4.getObservaciones());
		return vdocos4;
	}

	/**
	 * Updates a single row in the VdocOs4 table.
	 * 
	 *  vdocos4
	 *            VdocOs4
	 *  VdocOs4
	 *
	 * @param vdocos4 the vdocos 4
	 * @return the vdoc os 4
	 */
	public VdocOs4 update(VdocOs4 vdocos4) {
		String query = "UPDATE VDOC_OS4 SET  WHERE NUMEXP=? AND DIRECCION=? AND PROMOTOR=? AND CONTRATA=? AND AVISOSI=? AND AVISONO=? AND COMUNICACIONSI=? AND COMUICACIONNO=? AND PLANSI=? AND PLANNO=? AND COORDINADOR=? AND EXPEDIENTE=? AND FECHA=? AND NOMBREEMPRESA=? AND PROMO=? AND CON=? AND SUBCON=? AND AUT=? AND NOMRES1=? AND NOMRES2=? AND DESRES1=? AND DESRES2=? AND NOMREP=? AND REPRESENTACION=? AND CODCAU01=? AND CODCAU02=? AND CODCAU03=? AND CODCAU04=? AND CODCAU05=? AND CODCAU06=? AND CODCAU07=? AND CODCAU08=? AND CODCAU09=? AND CODCAU10=? AND OBSERVACIONES=?";
		this.jdbcTemplate.update(query, vdocos4.getNumexp(),
				vdocos4.getDireccion(), vdocos4.getPromotor(),
				vdocos4.getContrata(), vdocos4.getAvisosi(),
				vdocos4.getAvisono(), vdocos4.getComunicacionsi(),
				vdocos4.getComunicacionno(), vdocos4.getPlansi(),
				vdocos4.getPlanno(), vdocos4.getCoordinador(),
				vdocos4.getExpediente(), vdocos4.getFecha(),
				vdocos4.getNombreempresa(), vdocos4.getPromo(),
				vdocos4.getCon(), vdocos4.getSubcon(), vdocos4.getAut(),
				vdocos4.getNomres1(), vdocos4.getNomres2(),
				vdocos4.getDesres1(), vdocos4.getDesres2(),
				vdocos4.getNomrep(), vdocos4.getRepresentacion(),
				vdocos4.getCodcau01(), vdocos4.getCodcau02(),
				vdocos4.getCodcau03(), vdocos4.getCodcau04(),
				vdocos4.getCodcau05(), vdocos4.getCodcau06(),
				vdocos4.getCodcau07(), vdocos4.getCodcau08(),
				vdocos4.getCodcau09(), vdocos4.getCodcau10(),
				vdocos4.getObservaciones());
		return vdocos4;
	}

	/**
	 * Finds a single row in the VdocOs4 table.
	 * 
	 *  vdocos4
	 *            VdocOs4
	 *  VdocOs4
	 *
	 * @param vdocos4 the vdocos 4
	 * @return the vdoc os 4
	 */
	@Transactional(readOnly = true)
	public VdocOs4 find(VdocOs4 vdocos4) {
		String query = "SELECT t1.NUMEXP NUMEXP, t1.NUMEJE NUMEJE, t1.DIRECCION DIRECCION, t1.PROMOTOR PROMOTOR, t1.CONTRATA CONTRATA, t1.AVISOSI AVISOSI, t1.AVISONO AVISONO, t1.COMUNICACIONSI COMUNICACIONSI, t1.COMUICACIONNO COMUICACIONNO, t1.PLANSI PLANSI, t1.PLANNO PLANNO, t1.COORDINADOR COORDINADOR, t1.EXPEDIENTE EXPEDIENTE, t1.FECHA FECHA, t1.NOMBREEMPRESA NOMBREEMPRESA, t1.PROMO PROMO, t1.CON CON, t1.SUBCON SUBCON, t1.AUT AUT, t1.NOMRES1 NOMRES1, t1.NOMRES2 NOMRES2, t1.DESRES1 DESRES1, t1.DESRES2 DESRES2, t1.NOMREP NOMREP, t1.REPRESENTACION REPRESENTACION, t1.CODCAU01 CODCAU01, t1.CODCAU02 CODCAU02, t1.CODCAU03 CODCAU03, t1.CODCAU04 CODCAU04, t1.CODCAU05 CODCAU05, t1.CODCAU06 CODCAU06, t1.CODCAU07 CODCAU07, t1.CODCAU08 CODCAU08, t1.CODCAU09 CODCAU09, t1.CODCAU10 CODCAU10, t1.OBSERVACIONES OBSERVACIONES FROM VDOC_OS4 t1  WHERE t1.NUMEXP = ? AND t1.NUMEJE = ? ";

		List<VdocOs4> vdocos4List = this.jdbcTemplate.query(query, this.rwMap,
				vdocos4.getNumexp(), vdocos4.getNumeje());
		return (VdocOs4) DataAccessUtils.uniqueResult(vdocos4List);
	}

	/**
	 * Removes a single row in the VdocOs4 table.
	 * 
	 *  vdocos4            VdocOs4
	 *
	 * @param vdocos4 the vdocos 4
	 */
	public void remove(VdocOs4 vdocos4) {
		String query = "DELETE FROM VDOC_OS4 WHERE NUMEXP=? AND NUMEJE=? AND DIRECCION=? AND PROMOTOR=? AND CONTRATA=? AND AVISOSI=? AND AVISONO=? AND COMUNICACIONSI=? AND COMUICACIONNO=? AND PLANSI=? AND PLANNO=? AND COORDINADOR=? AND EXPEDIENTE=? AND FECHA=? AND NOMBREEMPRESA=? AND PROMO=? AND CON=? AND SUBCON=? AND AUT=? AND NOMRES1=? AND NOMRES2=? AND DESRES1=? AND DESRES2=? AND NOMREP=? AND REPRESENTACION=? AND CODCAU01=? AND CODCAU02=? AND CODCAU03=? AND CODCAU04=? AND CODCAU05=? AND CODCAU06=? AND CODCAU07=? AND CODCAU08=? AND CODCAU09=? AND CODCAU10=? AND OBSERVACIONES=?";
		this.jdbcTemplate.update(query, vdocos4.getNumexp(), vdocos4.getNumeje(),
				vdocos4.getDireccion(), vdocos4.getPromotor(),
				vdocos4.getContrata(), vdocos4.getAvisosi(),
				vdocos4.getAvisono(), vdocos4.getComunicacionsi(),
				vdocos4.getComunicacionno(), vdocos4.getPlansi(),
				vdocos4.getPlanno(), vdocos4.getCoordinador(),
				vdocos4.getExpediente(), vdocos4.getFecha(),
				vdocos4.getNombreempresa(), vdocos4.getPromo(),
				vdocos4.getCon(), vdocos4.getSubcon(), vdocos4.getAut(),
				vdocos4.getNomres1(), vdocos4.getNomres2(),
				vdocos4.getDesres1(), vdocos4.getDesres2(),
				vdocos4.getNomrep(), vdocos4.getRepresentacion(),
				vdocos4.getCodcau01(), vdocos4.getCodcau02(),
				vdocos4.getCodcau03(), vdocos4.getCodcau04(),
				vdocos4.getCodcau05(), vdocos4.getCodcau06(),
				vdocos4.getCodcau07(), vdocos4.getCodcau08(),
				vdocos4.getCodcau09(), vdocos4.getCodcau10(),
				vdocos4.getObservaciones());
	}

	/**
	 * Finds a list of rows in the VdocOs4 table.
	 * 
	 *  vdocos4
	 *            VdocOs4
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<VdocOs4>
	 *
	 * @param vdocos4 the vdocos 4
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VdocOs4> findAll(VdocOs4 vdocos4,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.NUMEJE NUMEJE,t1.DIRECCION DIRECCION,t1.PROMOTOR PROMOTOR,t1.CONTRATA CONTRATA,t1.AVISOSI AVISOSI,t1.AVISONO AVISONO,t1.COMUNICACIONSI COMUNICACIONSI,t1.COMUICACIONNO COMUICACIONNO,t1.PLANSI PLANSI,t1.PLANNO PLANNO,t1.COORDINADOR COORDINADOR,t1.EXPEDIENTE EXPEDIENTE,t1.FECHA FECHA,t1.NOMBREEMPRESA NOMBREEMPRESA,t1.PROMO PROMO,t1.CON CON,t1.SUBCON SUBCON,t1.AUT AUT,t1.NOMRES1 NOMRES1,t1.NOMRES2 NOMRES2,t1.DESRES1 DESRES1,t1.DESRES2 DESRES2,t1.NOMREP NOMREP,t1.REPRESENTACION REPRESENTACION,t1.CODCAU01 CODCAU01,t1.CODCAU02 CODCAU02,t1.CODCAU03 CODCAU03,t1.CODCAU04 CODCAU04,t1.CODCAU05 CODCAU05,t1.CODCAU06 CODCAU06,t1.CODCAU07 CODCAU07,t1.CODCAU08 CODCAU08,t1.CODCAU09 CODCAU09,t1.CODCAU10 CODCAU10,t1.OBSERVACIONES OBSERVACIONES ");
		query.append("FROM VDOC_OS4 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vdocos4);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VdocOs4>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the VdocOs4 table using like.
	 * 
	 *  vdocos4
	 *            VdocOs4
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<VdocOs4>
	 *
	 * @param vdocos4 the vdocos 4
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<VdocOs4> findAllLike(VdocOs4 vdocos4,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.NUMEXP NUMEXP,t1.NUMEJE NUMEJE,t1.DIRECCION DIRECCION,t1.PROMOTOR PROMOTOR,t1.CONTRATA CONTRATA,t1.AVISOSI AVISOSI,t1.AVISONO AVISONO,t1.COMUNICACIONSI COMUNICACIONSI,t1.COMUICACIONNO COMUICACIONNO,t1.PLANSI PLANSI,t1.PLANNO PLANNO,t1.COORDINADOR COORDINADOR,t1.EXPEDIENTE EXPEDIENTE,t1.FECHA FECHA,t1.NOMBREEMPRESA NOMBREEMPRESA,t1.PROMO PROMO,t1.CON CON,t1.SUBCON SUBCON,t1.AUT AUT,t1.NOMRES1 NOMRES1,t1.NOMRES2 NOMRES2,t1.DESRES1 DESRES1,t1.DESRES2 DESRES2,t1.NOMREP NOMREP,t1.REPRESENTACION REPRESENTACION,t1.CODCAU01 CODCAU01,t1.CODCAU02 CODCAU02,t1.CODCAU03 CODCAU03,t1.CODCAU04 CODCAU04,t1.CODCAU05 CODCAU05,t1.CODCAU06 CODCAU06,t1.CODCAU07 CODCAU07,t1.CODCAU08 CODCAU08,t1.CODCAU09 CODCAU09,t1.CODCAU10 CODCAU10,t1.OBSERVACIONES OBSERVACIONES ");
		query.append("FROM VDOC_OS4 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdocos4, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<VdocOs4>) this.jdbcTemplate.query(query.toString(),
				this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the VdocOs4 table.
	 * 
	 *  vdocos4
	 *            VdocOs4
	 *  Long
	 *
	 * @param vdocos4 the vdocos 4
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(VdocOs4 vdocos4) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VDOC_OS4 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(vdocos4);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the VdocOs4 table using like.
	 * 
	 *  vdocos4
	 *            VdocOs4
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param vdocos4 the vdocos 4
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(VdocOs4 vdocos4, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM VDOC_OS4 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdocos4, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of VdocOs4 selected for rup_table.
	 * 
	 *  vdocos4            VdocOs4
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VdocOs4>>
	 *
	 * @param vdocos4 the vdocos 4
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdocOs4>> reorderSelection(VdocOs4 vdocos4,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMEJE NUMEJE,t1.DIRECCION DIRECCION,t1.PROMOTOR PROMOTOR,t1.CONTRATA CONTRATA,t1.AVISOSI AVISOSI,t1.AVISONO AVISONO,t1.COMUNICACIONSI COMUNICACIONSI,t1.COMUICACIONNO COMUICACIONNO,t1.PLANSI PLANSI,t1.PLANNO PLANNO,t1.COORDINADOR COORDINADOR,t1.EXPEDIENTE EXPEDIENTE,t1.FECHA FECHA,t1.NOMBREEMPRESA NOMBREEMPRESA,t1.PROMO PROMO,t1.CON CON,t1.SUBCON SUBCON,t1.AUT AUT,t1.NOMRES1 NOMRES1,t1.NOMRES2 NOMRES2,t1.DESRES1 DESRES1,t1.DESRES2 DESRES2,t1.NOMREP NOMREP,t1.REPRESENTACION REPRESENTACION,t1.CODCAU01 CODCAU01,t1.CODCAU02 CODCAU02,t1.CODCAU03 CODCAU03,t1.CODCAU04 CODCAU04,t1.CODCAU05 CODCAU05,t1.CODCAU06 CODCAU06,t1.CODCAU07 CODCAU07,t1.CODCAU08 CODCAU08,t1.CODCAU09 CODCAU09,t1.CODCAU10 CODCAU10,t1.OBSERVACIONES OBSERVACIONES ");
		// FROM
		query.append("FROM VDOC_OS4 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(vdocos4, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getReorderQuery(
						query,
						jqGridRequestDto,
						VdocOs4.class,
						filterParamList,
						"NUMEXP,NUMEJE,DIRECCION,PROMOTOR,CONTRATA,AVISOSI,AVISONO,COMUNICACIONSI,COMUICACIONNO,PLANSI,PLANNO,COORDINADOR,EXPEDIENTE,FECHA,NOMBREEMPRESA,PROMO,CON,SUBCON,AUT,NOMRES1,NOMRES2,DESRES1,DESRES2,NOMREP,REPRESENTACION,CODCAU01,CODCAU02,CODCAU03,CODCAU04,CODCAU05,CODCAU06,CODCAU07,CODCAU08,CODCAU09,CODCAU10,OBSERVACIONES");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VdocOs4>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            VdocOs4
	 *  searchParams            VdocOs4
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<VdocOs4>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<VdocOs4>> search(VdocOs4 filterParams,
			VdocOs4 searchParams, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMEJE NUMEJE,t1.DIRECCION DIRECCION,t1.PROMOTOR PROMOTOR,t1.CONTRATA CONTRATA,t1.AVISOSI AVISOSI,t1.AVISONO AVISONO,t1.COMUNICACIONSI COMUNICACIONSI,t1.COMUICACIONNO COMUICACIONNO,t1.PLANSI PLANSI,t1.PLANNO PLANNO,t1.COORDINADOR COORDINADOR,t1.EXPEDIENTE EXPEDIENTE,t1.FECHA FECHA,t1.NOMBREEMPRESA NOMBREEMPRESA,t1.PROMO PROMO,t1.CON CON,t1.SUBCON SUBCON,t1.AUT AUT,t1.NOMRES1 NOMRES1,t1.NOMRES2 NOMRES2,t1.DESRES1 DESRES1,t1.DESRES2 DESRES2,t1.NOMREP NOMREP,t1.REPRESENTACION REPRESENTACION,t1.CODCAU01 CODCAU01,t1.CODCAU02 CODCAU02,t1.CODCAU03 CODCAU03,t1.CODCAU04 CODCAU04,t1.CODCAU05 CODCAU05,t1.CODCAU06 CODCAU06,t1.CODCAU07 CODCAU07,t1.CODCAU08 CODCAU08,t1.CODCAU09 CODCAU09,t1.CODCAU10 CODCAU10,t1.OBSERVACIONES OBSERVACIONES ");
		// FROM
		query.append("FROM VDOC_OS4 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager
				.getSearchQuery(
						query,
						jqGridRequestDto,
						VdocOs4.class,
						filterParamList,
						searchSQL,
						searchParamList,
						from_alias,
						"NUMEXP,NUMEJE,DIRECCION,PROMOTOR,CONTRATA,AVISOSI,AVISONO,COMUNICACIONSI,COMUICACIONNO,PLANSI,PLANNO,COORDINADOR,EXPEDIENTE,FECHA,NOMBREEMPRESA,PROMO,CON,SUBCON,AUT,NOMRES1,NOMRES2,DESRES1,DESRES2,NOMREP,REPRESENTACION,CODCAU01,CODCAU02,CODCAU03,CODCAU04,CODCAU05,CODCAU06,CODCAU07,CODCAU08,CODCAU09,CODCAU10,OBSERVACIONES");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<VdocOs4>(this.rwMapPK,
						jqGridRequestDto), filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filtervdocos4            VdocOs4
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filtervdocos4 the filtervdocos 4
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(VdocOs4 filtervdocos4,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.NUMEXP NUMEXP,t1.NUMEJE NUMEJE,t1.DIRECCION DIRECCION,t1.PROMOTOR PROMOTOR,t1.CONTRATA CONTRATA,t1.AVISOSI AVISOSI,t1.AVISONO AVISONO,t1.COMUNICACIONSI COMUNICACIONSI,t1.COMUICACIONNO COMUICACIONNO,t1.PLANSI PLANSI,t1.PLANNO PLANNO,t1.COORDINADOR COORDINADOR,t1.EXPEDIENTE EXPEDIENTE,t1.FECHA FECHA,t1.NOMBREEMPRESA NOMBREEMPRESA,t1.PROMO PROMO,t1.CON CON,t1.SUBCON SUBCON,t1.AUT AUT,t1.NOMRES1 NOMRES1,t1.NOMRES2 NOMRES2,t1.DESRES1 DESRES1,t1.DESRES2 DESRES2,t1.NOMREP NOMREP,t1.REPRESENTACION REPRESENTACION,t1.CODCAU01 CODCAU01,t1.CODCAU02 CODCAU02,t1.CODCAU03 CODCAU03,t1.CODCAU04 CODCAU04,t1.CODCAU05 CODCAU05,t1.CODCAU06 CODCAU06,t1.CODCAU07 CODCAU07,t1.CODCAU08 CODCAU08,t1.CODCAU09 CODCAU09,t1.CODCAU10 CODCAU10,t1.OBSERVACIONES OBSERVACIONES ");
		// FROM
		query.append("FROM VDOC_OS4 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filtervdocos4,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(
						jqGridRequestDto,
						VdocOs4.class,
						query,
						params,
						"NUMEXP,NUMEJE,DIRECCION,PROMOTOR,CONTRATA,AVISOSI,AVISONO,COMUNICACIONSI,COMUICACIONNO,PLANSI,PLANNO,COORDINADOR,EXPEDIENTE,FECHA,NOMBREEMPRESA,PROMO,CON,SUBCON,AUT,NOMRES1,NOMRES2,DESRES1,DESRES2,NOMREP,REPRESENTACION,CODCAU01,CODCAU02,CODCAU03,CODCAU04,CODCAU05,CODCAU06,CODCAU07,CODCAU08,CODCAU09,CODCAU10,OBSERVACIONES");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VdocOs4 entity.
	 * 
	 *  vdocos4            VdocOs4 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vdocos4 the vdocos 4
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(VdocOs4 vdocos4) {

		StringBuilder where = new StringBuilder(
				VdocOs4DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vdocos4 != null && vdocos4.getNumexp() != null) {
			where.append(" AND t1.NUMEXP = ?");
			params.add(vdocos4.getNumexp());
		}
		if (vdocos4 != null && vdocos4.getNumeje() != null) {
			where.append(" AND t1.NUMEJE = ?");
			params.add(vdocos4.getNumeje());
		}
		if (vdocos4 != null && vdocos4.getDireccion() != null) {
			where.append(" AND t1.DIRECCION = ?");
			params.add(vdocos4.getDireccion());
		}
		if (vdocos4 != null && vdocos4.getPromotor() != null) {
			where.append(" AND t1.PROMOTOR = ?");
			params.add(vdocos4.getPromotor());
		}
		if (vdocos4 != null && vdocos4.getContrata() != null) {
			where.append(" AND t1.CONTRATA = ?");
			params.add(vdocos4.getContrata());
		}
		if (vdocos4 != null && vdocos4.getAvisosi() != null) {
			where.append(" AND t1.AVISOSI = ?");
			params.add(vdocos4.getAvisosi());
		}
		if (vdocos4 != null && vdocos4.getAvisono() != null) {
			where.append(" AND t1.AVISONO = ?");
			params.add(vdocos4.getAvisono());
		}
		if (vdocos4 != null && vdocos4.getComunicacionsi() != null) {
			where.append(" AND t1.COMUNICACIONSI = ?");
			params.add(vdocos4.getComunicacionsi());
		}
		if (vdocos4 != null && vdocos4.getComunicacionno() != null) {
			where.append(" AND t1.COMUICACIONNO = ?");
			params.add(vdocos4.getComunicacionno());
		}
		if (vdocos4 != null && vdocos4.getPlansi() != null) {
			where.append(" AND t1.PLANSI = ?");
			params.add(vdocos4.getPlansi());
		}
		if (vdocos4 != null && vdocos4.getPlanno() != null) {
			where.append(" AND t1.PLANNO = ?");
			params.add(vdocos4.getPlanno());
		}
		if (vdocos4 != null && vdocos4.getCoordinador() != null) {
			where.append(" AND t1.COORDINADOR = ?");
			params.add(vdocos4.getCoordinador());
		}
		if (vdocos4 != null && vdocos4.getExpediente() != null) {
			where.append(" AND t1.EXPEDIENTE = ?");
			params.add(vdocos4.getExpediente());
		}
		if (vdocos4 != null && vdocos4.getFecha() != null) {
			where.append(" AND t1.FECHA = ?");
			params.add(vdocos4.getFecha());
		}
		if (vdocos4 != null && vdocos4.getNombreempresa() != null) {
			where.append(" AND t1.NOMBREEMPRESA = ?");
			params.add(vdocos4.getNombreempresa());
		}
		if (vdocos4 != null && vdocos4.getPromo() != null) {
			where.append(" AND t1.PROMO = ?");
			params.add(vdocos4.getPromo());
		}
		if (vdocos4 != null && vdocos4.getCon() != null) {
			where.append(" AND t1.CON = ?");
			params.add(vdocos4.getCon());
		}
		if (vdocos4 != null && vdocos4.getSubcon() != null) {
			where.append(" AND t1.SUBCON = ?");
			params.add(vdocos4.getSubcon());
		}
		if (vdocos4 != null && vdocos4.getAut() != null) {
			where.append(" AND t1.AUT = ?");
			params.add(vdocos4.getAut());
		}
		if (vdocos4 != null && vdocos4.getNomres1() != null) {
			where.append(" AND t1.NOMRES1 = ?");
			params.add(vdocos4.getNomres1());
		}
		if (vdocos4 != null && vdocos4.getNomres2() != null) {
			where.append(" AND t1.NOMRES2 = ?");
			params.add(vdocos4.getNomres2());
		}
		if (vdocos4 != null && vdocos4.getDesres1() != null) {
			where.append(" AND t1.DESRES1 = ?");
			params.add(vdocos4.getDesres1());
		}
		if (vdocos4 != null && vdocos4.getDesres2() != null) {
			where.append(" AND t1.DESRES2 = ?");
			params.add(vdocos4.getDesres2());
		}
		if (vdocos4 != null && vdocos4.getNomrep() != null) {
			where.append(" AND t1.NOMREP = ?");
			params.add(vdocos4.getNomrep());
		}
		if (vdocos4 != null && vdocos4.getRepresentacion() != null) {
			where.append(" AND t1.REPRESENTACION = ?");
			params.add(vdocos4.getRepresentacion());
		}
		if (vdocos4 != null && vdocos4.getCodcau01() != null) {
			where.append(" AND t1.CODCAU01 = ?");
			params.add(vdocos4.getCodcau01());
		}
		if (vdocos4 != null && vdocos4.getCodcau02() != null) {
			where.append(" AND t1.CODCAU02 = ?");
			params.add(vdocos4.getCodcau02());
		}
		if (vdocos4 != null && vdocos4.getCodcau03() != null) {
			where.append(" AND t1.CODCAU03 = ?");
			params.add(vdocos4.getCodcau03());
		}
		if (vdocos4 != null && vdocos4.getCodcau04() != null) {
			where.append(" AND t1.CODCAU04 = ?");
			params.add(vdocos4.getCodcau04());
		}
		if (vdocos4 != null && vdocos4.getCodcau05() != null) {
			where.append(" AND t1.CODCAU05 = ?");
			params.add(vdocos4.getCodcau05());
		}
		if (vdocos4 != null && vdocos4.getCodcau06() != null) {
			where.append(" AND t1.CODCAU06 = ?");
			params.add(vdocos4.getCodcau06());
		}
		if (vdocos4 != null && vdocos4.getCodcau07() != null) {
			where.append(" AND t1.CODCAU07 = ?");
			params.add(vdocos4.getCodcau07());
		}
		if (vdocos4 != null && vdocos4.getCodcau08() != null) {
			where.append(" AND t1.CODCAU08 = ?");
			params.add(vdocos4.getCodcau08());
		}
		if (vdocos4 != null && vdocos4.getCodcau09() != null) {
			where.append(" AND t1.CODCAU09 = ?");
			params.add(vdocos4.getCodcau09());
		}
		if (vdocos4 != null && vdocos4.getCodcau10() != null) {
			where.append(" AND t1.CODCAU10 = ?");
			params.add(vdocos4.getCodcau10());
		}
		if (vdocos4 != null && vdocos4.getObservaciones() != null) {
			where.append(" AND t1.OBSERVACIONES = ?");
			params.add(vdocos4.getObservaciones());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the VdocOs4 entity.
	 * 
	 *  vdocos4            VdocOs4 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param vdocos4 the vdocos 4
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(VdocOs4 vdocos4,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				VdocOs4DaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (vdocos4 != null && vdocos4.getNumexp() != null) {
			where.append(" AND UPPER(t1.NUMEXP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getNumexp().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getNumexp().toUpperCase() + "%");
			}
			where.append(" AND t1.NUMEXP IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getNumeje() != null) {
			where.append(" AND t1.NUMEJE = ?");
			params.add(vdocos4.getNumeje());
		}
		if (vdocos4 != null && vdocos4.getDireccion() != null) {
			where.append(" AND UPPER(t1.DIRECCION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getDireccion().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getDireccion().toUpperCase() + "%");
			}
			where.append(" AND t1.DIRECCION IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getPromotor() != null) {
			where.append(" AND UPPER(t1.PROMOTOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getPromotor().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getPromotor().toUpperCase() + "%");
			}
			where.append(" AND t1.PROMOTOR IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getContrata() != null) {
			where.append(" AND UPPER(t1.CONTRATA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getContrata().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getContrata().toUpperCase() + "%");
			}
			where.append(" AND t1.CONTRATA IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getAvisosi() != null) {
			where.append(" AND UPPER(t1.AVISOSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getAvisosi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getAvisosi().toUpperCase() + "%");
			}
			where.append(" AND t1.AVISOSI IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getAvisono() != null) {
			where.append(" AND UPPER(t1.AVISONO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getAvisono().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getAvisono().toUpperCase() + "%");
			}
			where.append(" AND t1.AVISONO IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getComunicacionsi() != null) {
			where.append(" AND UPPER(t1.COMUNICACIONSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getComunicacionsi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getComunicacionsi().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.COMUNICACIONSI IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getComunicacionno() != null) {
			where.append(" AND UPPER(t1.COMUICACIONNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getComunicacionno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getComunicacionno().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.COMUICACIONNO IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getPlansi() != null) {
			where.append(" AND UPPER(t1.PLANSI) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getPlansi().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getPlansi().toUpperCase() + "%");
			}
			where.append(" AND t1.PLANSI IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getPlanno() != null) {
			where.append(" AND UPPER(t1.PLANNO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getPlanno().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getPlanno().toUpperCase() + "%");
			}
			where.append(" AND t1.PLANNO IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCoordinador() != null) {
			where.append(" AND UPPER(t1.COORDINADOR) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCoordinador().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCoordinador().toUpperCase() + "%");
			}
			where.append(" AND t1.COORDINADOR IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getExpediente() != null) {
			where.append(" AND t1.EXPEDIENTE = ?");
			params.add(vdocos4.getExpediente());
		}
		if (vdocos4 != null && vdocos4.getFecha() != null) {
			where.append(" AND t1.FECHA = ?");
			params.add(vdocos4.getFecha());
		}
		if (vdocos4 != null && vdocos4.getNombreempresa() != null) {
			where.append(" AND UPPER(t1.NOMBREEMPRESA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getNombreempresa().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getNombreempresa().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMBREEMPRESA IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getPromo() != null) {
			where.append(" AND UPPER(t1.PROMO) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getPromo().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getPromo().toUpperCase() + "%");
			}
			where.append(" AND t1.PROMO IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCon() != null) {
			where.append(" AND UPPER(t1.CON) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCon().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCon().toUpperCase() + "%");
			}
			where.append(" AND t1.CON IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getSubcon() != null) {
			where.append(" AND UPPER(t1.SUBCON) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getSubcon().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getSubcon().toUpperCase() + "%");
			}
			where.append(" AND t1.SUBCON IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getAut() != null) {
			where.append(" AND UPPER(t1.AUT) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getAut().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getAut().toUpperCase() + "%");
			}
			where.append(" AND t1.AUT IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getNomres1() != null) {
			where.append(" AND UPPER(t1.NOMRES1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getNomres1().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getNomres1().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMRES1 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getNomres2() != null) {
			where.append(" AND UPPER(t1.NOMRES2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getNomres2().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getNomres2().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMRES2 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getDesres1() != null) {
			where.append(" AND UPPER(t1.DESRES1) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getDesres1().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getDesres1().toUpperCase() + "%");
			}
			where.append(" AND t1.DESRES1 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getDesres2() != null) {
			where.append(" AND UPPER(t1.DESRES2) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getDesres2().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getDesres2().toUpperCase() + "%");
			}
			where.append(" AND t1.DESRES2 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getNomrep() != null) {
			where.append(" AND UPPER(t1.NOMREP) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getNomrep().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getNomrep().toUpperCase() + "%");
			}
			where.append(" AND t1.NOMREP IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getRepresentacion() != null) {
			where.append(" AND UPPER(t1.REPRESENTACION) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getRepresentacion().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getRepresentacion().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.REPRESENTACION IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCodcau01() != null) {
			where.append(" AND UPPER(t1.CODCAU01) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCodcau01().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCodcau01().toUpperCase() + "%");
			}
			where.append(" AND t1.CODCAU01 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCodcau02() != null) {
			where.append(" AND UPPER(t1.CODCAU02) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCodcau02().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCodcau02().toUpperCase() + "%");
			}
			where.append(" AND t1.CODCAU02 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCodcau03() != null) {
			where.append(" AND UPPER(t1.CODCAU03) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCodcau03().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCodcau03().toUpperCase() + "%");
			}
			where.append(" AND t1.CODCAU03 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCodcau04() != null) {
			where.append(" AND UPPER(t1.CODCAU04) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCodcau04().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCodcau04().toUpperCase() + "%");
			}
			where.append(" AND t1.CODCAU04 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCodcau05() != null) {
			where.append(" AND UPPER(t1.CODCAU05) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCodcau05().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCodcau05().toUpperCase() + "%");
			}
			where.append(" AND t1.CODCAU05 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCodcau06() != null) {
			where.append(" AND UPPER(t1.CODCAU06) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCodcau06().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCodcau06().toUpperCase() + "%");
			}
			where.append(" AND t1.CODCAU06 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCodcau07() != null) {
			where.append(" AND UPPER(t1.CODCAU07) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCodcau07().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCodcau07().toUpperCase() + "%");
			}
			where.append(" AND t1.CODCAU07 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCodcau08() != null) {
			where.append(" AND UPPER(t1.CODCAU08) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCodcau08().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCodcau08().toUpperCase() + "%");
			}
			where.append(" AND t1.CODCAU08 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCodcau09() != null) {
			where.append(" AND UPPER(t1.CODCAU09) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCodcau09().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCodcau09().toUpperCase() + "%");
			}
			where.append(" AND t1.CODCAU09 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getCodcau10() != null) {
			where.append(" AND UPPER(t1.CODCAU10) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getCodcau10().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getCodcau10().toUpperCase() + "%");
			}
			where.append(" AND t1.CODCAU10 IS NOT NULL");
		}
		if (vdocos4 != null && vdocos4.getObservaciones() != null) {
			where.append(" AND UPPER(t1.OBSERVACIONES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(vdocos4.getObservaciones().toUpperCase() + "%");
			} else {
				params.add("%" + vdocos4.getObservaciones().toUpperCase() + "%");
			}
			where.append(" AND t1.OBSERVACIONES IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
